<?php
namespace App\Http\VCardApi;

use JeroenDesloovere\VCard\VCard;
 
class VCardApi extends Vcard
{
    /**
     * Get charset string
     *
     * @return string
     */
    /*
    public function getCharsetString()
    {
        return '';
    }
*/
    /**
     * Build VCard (.vcf)
     *
     * @return string
     */

    public function buildVCard()
    {
        // init string
        $string = "BEGIN:VCARD\r\n";
        $string .= "VERSION:3.0\r\n";

        $string = "BEGIN:VCARD\n";
        $string .= "VERSION:3.0\n";
        //$string .= "REV:" . date("Y-m-d") . "T" . date("H:i:s") . "Z\r\n";

        // loop all properties
        $properties = $this->getProperties();
        /*
        foreach ($properties as $property) {
            // add to string
            $string .= $this->fold($property['key'] . ':' . $this->escape($property['value']) . "\r\n");
        }
        */

        foreach ($properties as $property) {
            // add to string
            $string .= $this->fold($property['key'] . ':' . $this->clearcharset($property['value']) . "\n");
        }

        // add to string
        $string .= "END:VCARD";

        // return
        return $string;
    }

    private function clearcharset($property){

        
        return $property;
        /*
        $originales = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿ';
        $modificadas = 'aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyyby';
        
        $cadena = utf8_decode($property);
        $cadena = strtr($cadena, utf8_decode($originales), $modificadas);
        return utf8_encode($cadena);*/
    }

}
