<?php

namespace App\Http\Controllers;

use App\Http\Connection\ConnBigQuery;
use App\Http\VCardApi\VCardApi;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;


class VcardController extends Controller
{
    private $idioma = 'en';


    private $estaticos = array(
        'es' => array(
            "titulo" => "LLYC Vcards",
            "derechos" => "Todos los derechos reservados",
            "contacto" => "Contacto",
            "redes" => "Redes sociales",
            "qr_perfil" => "QR Perfil Digital",
            "qr_vcard" => "QR Vcard",
            "title_send_email" => "Enviar email a",
            "title_phone" => "Llamar a",
            "title_gmaps" => "Ver en Google Maps",
            "title_blank" => "(abre en ventana nueva)",
        ),
        'en' => array(
            "titulo" => "LLYC Vcards",
            "derechos" => "All rights reserved",
            "contacto" => "Contact",
            "redes" => "Social networks",
            "qr_perfil" => "QR Digital Profile",
            "qr_vcard" => "QR Vcard",
            "title_send_email" => "Send email to",
            "title_phone" => "Call to",
            "title_gmaps" => "See on Google Maps",
            "title_blank" => "(opens in a new window)",
        ),
        'br' => array(
            "titulo" => "Vcards LLYC",
            "derechos" => "Todos os direitos reservados",
            "contacto" => "Contato",
            "redes" => "Redes sociais",
            "qr_perfil" => "QR Perfil Digital",
            "qr_vcard" => "QR Vcard",
            "title_send_email" => "Enviar um email a",
            "title_phone" => "Chamar a",
            "title_gmaps" => "Veja no Google Maps",
            "title_blank" => "(abre em uma nova janela)",
        ),
        'pt' => array(
            "titulo" => "Vcards LLYC",
            "derechos" => "Todos os direitos reservados",
            "contacto" => "Contato",
            "redes" => "Redes sociais",
            "qr_perfil" => "QR Perfil Digital",
            "qr_vcard" => "QR Vcard",
            "title_send_email" => "Enviar um email a",
            "title_phone" => "Chamar a",
            "title_gmaps" => "Veja no Google Maps",
            "title_blank" => "(abre em uma nova janela)",
        ),
    );


    private $data_example=array(
        "1" => array(
            "division"  => "LVCé",
            "nombre"    => "Daniel",
            "apellidos" => "Fernández Trejo",
            "nombre_completo" => "Daniel Fernández Trejo",
            "email"     => "dfernandez@llorenteycuenca.com",
            "cargo_firma"     => "Dirección General Global",
            "compania"  => "LLORENTE & CUENCA MADRID",
            "categoria" => "Dirección General Global",
            "unidad_negocio"   => "DDB",
            "direccion_linea_1" => "Lagasca, 88 - planta 3",
            "direccion_linea_2" => "28001 Madrid (España)",
            "telefono_oficina"  => "+34 91 563 77 22",
            "movil"     => "606010203",
            "photo"    => "https://www.llorenteycuenca.com/wp-content/uploads/2019/03/RB_Baja-4960.jpg",
            "linkedin"  => "https://www.linkedin.com/in/dftrejo/",
            "twitter"   => "@danielfetr",
            "mimeType"  => "image/jpeg",
        ),

        "2" => array(
            "division"  => "LVCé",
            "nombre"    => "José Luis",
            "apellidos" => "Rodríguez",
            "nombre_completo" => "José Luis Rodríguez",
            "email"     => "jlrodriguez@llorenteycuenca.com",
            "cargo_firma"     => "Director DDB",
            "compania"  => "LLORENTE & CUENCA MADRID",
            "categoria" => "Dirección General Global",
            "unidad_negocio"   => "DDB",
            "direccion_linea_1" => "Lagasca, 88 - planta 3",
            "direccion_linea_2" => "28001 Madrid (España)",
            "telefono_oficina"  => "+34 91 563 77 22",
            "movil"     => "606010203",
            "photo"    => "https://www.llorenteycuenca.com/wp-content/uploads/2019/10/JL_Rodriguez_Madrid_LLYC.png",
            "linkedin"  => "https://www.linkedin.com/in/jos%C3%A9-luis-rodr%C3%ADguez-hern%C3%A1ndez-3b978a9/",
            "twitter"   => "@joseluisro",
            "mimeType"  => "image/jpeg",
        ),

        "3" => array(
            "division"  => "LVCé",
            "nombre"    => "Mª Carmen",
            "apellidos" => "Sabater Goñi",
            "nombre_completo" => "Mª Carmen Sabater Goñi",
            "email"     => "mcsabater@llorenteycuenca.com",
            "cargo_firma"     => "Equipo de desarrollo",
            "compania"  => "LLORENTE & CUENCA MADRID",
            "categoria" => "Dirección General Global",
            "unidad_negocio"   => "DDB",
            "direccion_linea_1" => "Lagasca, 88 - planta 3",
            "direccion_linea_2" => "28001 Madrid (España)",
            "telefono_oficina"  => "+34 91 563 77 22",
            "movil"     => "606010203",
            //"photo"    => "https://www.llorenteycuenca.com/wp-content/uploads/2019/03/RB_Baja-4960.jpg",
            "linkedin"  => "https://www.linkedin.com/in/mcsabater/",
            "twitter"   => "@mcsabater",
            "mimeType"  => "image/jpeg",
        ),
    );


    private $projectId;
	private $datasetId;

	function __construct() {
		$this->projectId = env('BIGQUERY_PROJECTID');
		$this->datasetId = env('BIGQUERY_DATASETID');
	}


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, $id, $lang = null)
    {

        $data = request()->except('_token');

        foreach ($data as $clave => $valor){
            $data[$clave] = htmlspecialchars(strip_tags(str_replace(['"',"'"],'',$valor)));
        }

        if(!empty($lang)){
            $this->idioma = $lang;
            app()->setLocale($this->idioma);
        }

        $data['estaticos'] = $this->estaticos;
        $data['idioma'] = $this->idioma;


        if(!empty($id) ){
            $data['eid'] =  $id;

            $data['id_empleado'] =  $data['eid'];
            //$data['params'] = '?eid=' . $data['eid'];
            $data['params'] = '/' . $id;


            if(!empty($this->data_example[$data['eid']])){
                $datos_empleado = $this->data_example[$data['eid']];
            }


            $connBigQuery = new ConnBigQuery();

            // Sacamos los datos del empleado
            /*
            $sql_query="SELECT *
            FROM " . $this->projectId . "." . $this->datasetId . ".Employees_QR_Data
            WHERE usuario = '" . $data['id_empleado'] . "'
            ORDER BY CHAR_LENGTH (photo) DESC
            LIMIT 1" ;
            */

            // Por email OLD
            /*$sql_query="SELECT *
            FROM " . $this->projectId . "." . $this->datasetId . ".Employees_QR_Data
            WHERE email LIKE '" . $data['id_empleado'] . "@%'
            ORDER BY CHAR_LENGTH (photo) DESC
            LIMIT 1" ;
            */

            // New table tal_current_employees
            /*
            SELECT 
            psn_last_name,              --apellidos 
            psn_first_name,             --nombre
            psn_full_name,              --nombre_completo
            psn_email,                  --email
            psn_job_title,              --cargo_firma
            psn_job_company_lbl,        --compania
            psn_job_category_lbl,       --categoria
            psn_job_business_unit_lbl,  --unidad_negocio
            psn_job_office_address_line_1,  --address_line1                              <-----------
            psn_job_office_address_line_2,  --address_line2                              <-----------
            psn_job_office_phone,          --telefono de la oficina a la que pertenece   <-----------
            psn_landline_full_phone_number, --telefono_oficina (viene de Success)
            psn_office_mobile_full_phone_number,--movil oficina (viene de Success)
            psn_personal_mobile_full_phone_number,--movil_2 (viene de Success)
            psn_pic_url, --photo
            psn_linkedin, --linkedin
            psn_twitter, --twitter
            FROM `llyc-prj-dev-data-warehouse.talent.tal_current_employees`
            */


            $sql_query="SELECT *
            FROM " . $this->projectId . "." . $this->datasetId . ".tal_current_employees
            WHERE psn_email LIKE '" . $data['id_empleado'] . "@%' 
            LIMIT 1" ;


 


            $datos_empleados = $connBigQuery->getdata($sql_query);

            $datos_comunes = array(
                "vcardc"  => "LLYCVCardé",
               // "direccion_linea_1" => "Lagasca, 88 - planta 3",
                //"direccion_linea_2" => "28001 Madrid (España)",
                //"telefono_oficina"  => "+34 91 563 77 22",
                //"movil"     => "606010203",
                //"cargo_firma_en" => "prueba",
                //"phoneNumber_2" => "600000000"
            );

          


            foreach ($datos_empleados as $datos) {
                
				$datos_empleado = array_merge($datos, $datos_comunes);
                $datos_empleado['nombre'] = $datos_empleado['psn_first_name'];
                $datos_empleado['apellidos'] = $datos_empleado['psn_last_name'];
                $datos_empleado['nombre_completo'] = $datos_empleado['psn_full_name'];
                $datos_empleado['email'] = $datos_empleado['psn_email'];
                $datos_empleado['cargo_firma'] = $datos_empleado['psn_job_title'];
                $datos_empleado['compania'] = $datos_empleado['psn_job_company_lbl'];
                $datos_empleado['categoria'] = $datos_empleado['psn_job_category_lbl'];
                $datos_empleado['unidad_negocio'] = $datos_empleado['psn_job_business_unit_lbl'];
                
                $datos_empleado['direccion_linea_1'] = $datos_empleado['psn_job_office_address_line_1'];
                $datos_empleado['direccion_linea_2'] = $datos_empleado['psn_job_office_address_line_2'];

                $datos_empleado['telefono_oficina'] = $datos_empleado['psn_job_office_phone'];                
                $datos_empleado['movil'] = $datos_empleado['psn_office_mobile_full_phone_number'];

                $datos_empleado['photo'] = $datos_empleado['psn_pic_url'];
                $datos_empleado['linkedin'] = $datos_empleado['psn_linkedin'];
                $datos_empleado['twitter'] = $datos_empleado['psn_twitter'];


               


                if(empty($datos_empleado['cargo_firma'])){
                    $datos_empleado['cargo_firma'] = $datos_empleado['division'] . " - " . $datos_empleado['categoria'];
                }
                /*if( $data['idioma'] != 'es'){
                    $datos_empleado['cargo_firma'] =  $datos_empleado['cargo_firma_' . $data['idioma']];
                }*/
			}
            /*echo "<pre>";

            print_r($datos_empleado);

            echo "</pre>";*/



            if(empty($datos_empleado)){
                $data['idioma'] = $this->idioma;
                Log::error('EMPLEADO: ' . $data['id_empleado'] . ' -- NO ENCONTRADO --');
                $data['mensaje'] = array(
                    'es' => "No encontramos el empleado que busca.",
                    'en' => "We did not find the employee you are looking for.",
                    'br' => "Não encontramos o funcionário que você está procurando.",
                    'pt' => "Não encontramos o funcionário que você está procurando.",
                );

                header('HTTP/1.0 404 Not Found', true, 404);
                return view('not-found', $data);

            } else {

                if(!empty($datos_empleado['linkedin'])){
                    $arr_linkedin = explode("/", $datos_empleado['linkedin']);
                    $datos_empleado['linkedin'] = $arr_linkedin[count($arr_linkedin)-1];
                }


                if(!empty($datos_empleado['twitter'])){
                    $arr_twitter = explode("/", $datos_empleado['twitter']);
                    $datos_empleado['twitter'] = $arr_twitter[count($arr_twitter)-1];
                }

                if(!empty($datos_empleado['direccion_linea_1'])){
                    $datos_empleado['direccion'] = $datos_empleado['direccion_linea_1'] . ", " . $datos_empleado['direccion_linea_2'];
                } else {
                    $datos_empleado['direccion'] = 'Lagasca, 88 - planta 3 28001 Madrid (España)';

                }

                if(!empty($datos_empleado['telefono_oficina'])){

                    if (strlen(str_replace(" " , "", $datos_empleado['telefono_oficina'])) == 12){

                        $datos_empleado['telefono_oficina'] = str_replace(" " , "", $datos_empleado['telefono_oficina']);
                        $datos_empleado['telefono_oficina'] = sprintf("%s %s %s %s %s", substr($datos_empleado['telefono_oficina'], 0, 3), substr($datos_empleado['telefono_oficina'], 3, 2), substr($datos_empleado['telefono_oficina'], 5, 3),substr($datos_empleado['telefono_oficina'], 8,2), substr($datos_empleado['telefono_oficina'], 10));
                    }

                }
                if(!empty($datos_empleado['movil'])){

                    if (strlen(str_replace(" " , "", $datos_empleado['movil'])) == 12){

                        $datos_empleado['movil'] = str_replace(" " , "", $datos_empleado['movil']);
                        $datos_empleado['movil'] = sprintf("%s %s %s %s %s", substr($datos_empleado['movil'], 0, 3), substr($datos_empleado['movil'], 3, 3), substr($datos_empleado['movil'], 6, 2), substr($datos_empleado['movil'], 8, 2), substr($datos_empleado['movil'], 10));
                    }

                }

                if(str_replace(" " , "", $datos_empleado['telefono_oficina']) == str_replace(" " , "", $datos_empleado['movil'])){
                    $datos_empleado['movil'] = "";
                }

                /*if(!empty($datos_empleado['phoneNumber'])){

                    if (strlen(str_replace(" " , "", $datos_empleado['phoneNumber'])) == 9){

                        $datos_empleado['phoneNumber'] = str_replace(" " , "", $datos_empleado['phoneNumber']);
                        $datos_empleado['phoneNumber'] = sprintf("%s %s %s %s", substr($datos_empleado['phoneNumber'], 0, 3), substr($datos_empleado['phoneNumber'], 3, 2), substr($datos_empleado['phoneNumber'], 5, 2), substr($datos_empleado['phoneNumber'], 7));
                    }


                    if (strlen(str_replace(" " , "", $datos_empleado['phoneNumber'])) == 10){

                        $datos_empleado['phoneNumber'] = str_replace(" " , "", $datos_empleado['phoneNumber']);

                        $datos_empleado['phoneNumber'] = sprintf("%s-%s-%s", substr($datos_empleado['phoneNumber'], 0, 3), substr($datos_empleado['phoneNumber'], 3, 3), substr($datos_empleado['phoneNumber'], 6));
                    }

                    if(strlen($datos_empleado['countryCode']) && stripos($datos_empleado['countryCode'], "+") === false){
                        $datos_empleado['countryCode'] = "+". $datos_empleado['countryCode'];
                    }

                    if($datos_empleado['telefono_oficina'] != ($datos_empleado['countryCode'] . " " . $datos_empleado['phoneNumber'])){
                        $datos_empleado['movil'] = $datos_empleado['countryCode'] . " " . $datos_empleado['phoneNumber'];
                    }
                }

                if(!empty($datos_empleado['phoneNumber_2'])){
                    $datos_empleado['movil_2'] = $datos_empleado['phoneNumber_2'];
                    if($datos_empleado['telefono_oficina'] == $datos_empleado['movil_2'] ){
                        $datos_empleado['telefono_oficina'] = '';
                    }
                }*/

                /* Generamos la card */

                $vcard = new VCardApi();

                $vcard->addRole($datos_empleado['vcardc']);
                // add personal data
                $vcard->addName($datos_empleado['apellidos'], $datos_empleado['nombre']);

                // add work data
                $vcard->addCompany($datos_empleado['compania']);
                $vcard->addJobtitle($datos_empleado['cargo_firma']);
                $vcard->addEmail($datos_empleado['email']);
                if(!empty($datos_empleado['movil'])){
                    //$vcard->addPhoneNumber($datos_empleado['movil'], 'PREF;CELL');
                    $vcard->addPhoneNumber($datos_empleado['movil'], 'TYPE=PREF');
                }
                /*if(!empty($datos_empleado['movil_2'])){
                    $vcard->addPhoneNumber($datos_empleado['movil_2'], 'TYPE=CELL');
                }*/
                if(!empty($datos_empleado['telefono_oficina'])){
                    $vcard->addPhoneNumber($datos_empleado['telefono_oficina'], 'TYPE=WORK');
                }

                $vcard->addAddress($datos_empleado['direccion']);
                $vcard->addURL('https://llyc.global');

                //$vcard->addPhoto($datos_empleado['imagen']);


                // return vcard as a string
                $data["vcard"] = preg_replace("[\n]", "\\n",preg_replace("[\r]", "",$vcard->getOutput()));
                $data["datos_empleado"] = $datos_empleado;
                return view('vcard', $data);
            }
        } else {
            Log::error('ACCESO SIN PARAMENTROS');

            header('HTTP/1.0 400 Bad Request', true, 400);

            $mensaje= array(
                'es' => 'Los parámetros recibidos no son correctos.',
                'en' => "The received parameters are not correct.",
                'br' => "Os parâmetros recebidos não estão corretos.",
                'pt' => "Os parâmetros recebidos não estão corretos.",
            );

            $data['mensaje'] =  $mensaje;
            $data['idioma'] = $this->idioma;
            $data['params'] = '?';
            return view('pages-error', $data);
        }






    }

    function notfound(){
        Log::error('ACCESO SIN PARAMENTROS');

        header('HTTP/1.0 400 Bad Request', true, 400);

        $mensaje= array(
            'es' => 'Los parámetros recibidos no son correctos.',
            'en' => "The received parameters are not correct.",
            'br' => "Os parâmetros recebidos não estão corretos.",
            'pt' => "Os parâmetros recebidos não estão corretos.",
        );

        $data['mensaje'] =  $mensaje;
        $data['estaticos'] = $this->estaticos;
        $data['idioma'] = $this->idioma;
        $data['params'] = '';
        return view('pages-error', $data);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

}
