<?php
namespace App\Http\Connection;

use Illuminate\Support\Facades\Storage;
use Google\Cloud\BigQuery\BigQueryClient;
use Exception;

class ConnBigQuery{

    private $projectId;
	private $serviceAccountPath;
	private $datasetId;
	
	function __construct() {
		$this->projectId = env('BIGQUERY_PROJECTID');
		$this->serviceAccountPath = Storage::path(env('BIGQUERY_CONFIG'));         
		$this->datasetId = env('BIGQUERY_DATASETID'); 
	}

   	
	/**
	 * Obtener datos de una tabla.
	 *
	 * @param string $tableId           	Identificador de la tabla.
	 * @param string $querysql				String query SQL
	 */	

	function getdata($querysql){

		// instantiate the bigquery table service
		$bigQuery = new BigQueryClient([
			'projectId' => $this->projectId,
			'keyFilePath' => $this->serviceAccountPath,
		]);

		
		// Run a query and inspect the results.
		$queryJobConfig = $bigQuery->query(
			$querysql
		);
		$queryResults = $bigQuery->runQuery($queryJobConfig);


		if ($queryResults->isComplete()) {

			$rows = $queryResults->rows();
			/*
			$i= 0;
			foreach ($rows as $row) {
				printf('--- Row %s ---' . PHP_EOL, ++$i);
				echo "<br><pre>";
				print_r($row);
				echo "</pre>";
				echo "<br>";
			}
			printf('Found %s row(s)' . PHP_EOL, $i);
			*/

			return $rows;
		} else {
			throw new Exception('The query failed to complete');
		}
	}


	/**
	 * Borrar los datos de una tabla.
	 *
	 * @param string $tableId           	Identificador de la tabla.
	 * @param string $querysql				String query SQL
	 */	

	function deletedata($tableId, $querysql){

		// instantiate the bigquery table service
		$bigQuery = new BigQueryClient([
			'projectId' => $this->projectId,
			'keyFilePath' => $this->serviceAccountPath,
		]);

		
		$dataset = $bigQuery->dataset($this->datasetId);
		$table = $dataset->table($tableId);


		// Run a query and inspect the results.
		$queryJobConfig = $bigQuery->query(
			$querysql
		);
		$queryResults = $bigQuery->runQuery($queryJobConfig);


		if ($queryResults->isComplete()) {

			$rows = $queryResults->rows();
			/*
			$i= 0;
			foreach ($rows as $row) {
				printf('--- Row %s ---' . PHP_EOL, ++$i);
				print_r($row);
				echo "<br>";
			}
			printf('Found %s row(s)' . PHP_EOL, $i);
			*/

			return $rows;
		} else {
			throw new Exception('The query failed to complete');
		}
	}
}
?>